/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KeyPairUtil {
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();
    private static String salt = "Apple@987";
    private static byte[] saltArr = salt.getBytes();

    public static KeyPair newKeyPair(String algorithm) throws NoSuchAlgorithmException {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(algorithm);
        return kpg.generateKeyPair();
    }

    public static byte[] getX509(PublicKey publicKey) {
        X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(publicKey.getEncoded());
        return x509EncodedKeySpec.getEncoded();
    }

    public static String getBase64X509(PublicKey publicKey) {
        return Base64.encode(KeyPairUtil.getX509(publicKey));
    }

    public static byte[] getPKCS8(PrivateKey privateKey) {
        PKCS8EncodedKeySpec pkcs8EncodedKeySpec = new PKCS8EncodedKeySpec(privateKey.getEncoded());
        return pkcs8EncodedKeySpec.getEncoded();
    }

    public static String getBase64PKCS8(PrivateKey privateKey) {
        return Base64.encode(KeyPairUtil.getPKCS8(privateKey));
    }

    public static PublicKey getFromX509(String algorithm, byte[] x509) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(x509);
        return keyFactory.generatePublic(publicKeySpec);
    }

    public static PublicKey getFromBase64X509(String algorithm, String b64x509) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return KeyPairUtil.getFromX509(algorithm, Base64.decode(b64x509));
    }

    public static PrivateKey getFromPKCS8(String algorithm, byte[] pkcs8) throws InvalidKeySpecException, NoSuchAlgorithmException {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(pkcs8);
        return keyFactory.generatePrivate(privateKeySpec);
    }

    public static PrivateKey getFromBase64PKCS8(String algorithm, String b64pkcs8) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return KeyPairUtil.getFromPKCS8(algorithm, Base64.decode(b64pkcs8));
    }

    public static KeyPair getFromX509_PKCS8(String algorithm, byte[] x509, byte[] pkcs8) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PublicKey publicKey = KeyPairUtil.getFromX509(algorithm, x509);
        PrivateKey privateKey = KeyPairUtil.getFromPKCS8(algorithm, pkcs8);
        return new KeyPair(publicKey, privateKey);
    }

    public static KeyPair getFromBase64_X509_PKCS8(String algorithm, String b64x509, String b64pkcs8) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return KeyPairUtil.getFromX509_PKCS8(algorithm, Base64.decode(b64x509), Base64.decode(b64pkcs8));
    }

    public static String getSHA256(String data) {
        StringBuilder sb = new StringBuilder();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(saltArr);
            byte[] byteData = md.digest(data.getBytes());
            sb.append(KeyPairUtil.bytesToHex(byteData));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
            ++j;
        }
        return String.valueOf(hexChars);
    }

    public static byte[] getSHA(String input, int i) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        return md.digest(input.getBytes(StandardCharsets.UTF_8));
    }

    public static String getSHA(String input) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        return KeyPairUtil.toHexString(md.digest(input.getBytes(StandardCharsets.UTF_8)), md);
    }

    public static String toHexString(byte[] hash, MessageDigest md) throws NoSuchAlgorithmException {
        BigInteger number = new BigInteger(1, hash);
        StringBuilder hexString = new StringBuilder(number.toString(16));
        while (hexString.length() < 64) {
            hexString.insert(0, '0');
        }
        System.out.println("hex=" + hexString.toString());
        return java.util.Base64.getEncoder().encodeToString(hash);
    }

    public static String getValueHash(String value, MessageDigest md, byte[] bh) throws NoSuchAlgorithmException {
        String tmpString = value;
        byte[] valueHash = md.digest(tmpString.getBytes());
        byte[] valueHash1 = value.getBytes(StandardCharsets.UTF_8);
        String hash = java.util.Base64.getEncoder().encodeToString(bh);
        System.out.println("hash=" + hash);
        String calculatedSsign = new String(java.util.Base64.getEncoder().encode(valueHash));
        return calculatedSsign;
    }
}

