/*
 * Decompiled with CFR 0.152.
 */
package util;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import util.JsoToMap;
import util.KeyPairUtil;

public class JwtTests {
    private static final String PUBLIC_KEY_X509_B64VALUE = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAw0NdX/PdIACQRIWRrFhT\nXizQ7w/7kPPYwNC3fjfu2QlL28sVZDzK2QxTtbwFKr//kTruRjJJA+uzNvcEALj9\n4mJN8HUQ1pmtq7J74T+Vhl7v2ZPeBLo20ewuonWLOEgxufaNBQpM0mRxir+zVa70\nf2RVHutEDG0gxu1dE+uIKYakK+2QFdqBMa1VClMyyGDj1yx7bxTT7GNjfaLkVucP\n/MxA3BpIPv+tHOjsea/XfNk+PofqWsLByZMMeAatcnZtQCJ2aNvt0SpAw7fV2qmZ\nJxZKcVSH2OAzEJSqbhAIN0pNIxNKj840svr3pSQv1OC/wFC/THjG+Qo9XJjey/lR\nKwIDAQAB";
    private static final String PRIVATE_KEY_PKCS8_B64VALUE = "MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDDQ11f890gAJBE\nhZGsWFNeLNDvD/uQ89jA0Ld+N+7ZCUvbyxVkPMrZDFO1vAUqv/+ROu5GMkkD67M2\n9wQAuP3iYk3wdRDWma2rsnvhP5WGXu/Zk94EujbR7C6idYs4SDG59o0FCkzSZHGK\nv7NVrvR/ZFUe60QMbSDG7V0T64gphqQr7ZAV2oExrVUKUzLIYOPXLHtvFNPsY2N9\nouRW5w/8zEDcGkg+/60c6Ox5r9d82T4+h+pawsHJkwx4Bq1ydm1AInZo2+3RKkDD\nt9XaqZknFkpxVIfY4DMQlKpuEAg3Sk0jE0qPzjSy+velJC/U4L/AUL9MeMb5Cj1c\nmN7L+VErAgMBAAECggEAAe19U4At064Nvo9vA7uPfyOEIIgQ3Lp7jlPBK/7TXdMo\nq4/Ssz2iZwgnH2kux+BDXqStS4YdkGtYRpejs3ogD4cW6+PL+cJko4hMjsm46S2w\nwn4iN/u6pNHnF/V/HVwhGYvkkoMqhP023b7Mv3DNuyA7cuWxs0m0hCI9w/+URYyp\nTGezqTixjsbvO5D4d5cvgDNYt9A5e3XspJXWUDdxwNCoWZt4+xQZ7dG6c3ft96PC\n4CZK2qSMdfuCenYwciIUUHwGg0xZX/d6xW8l5nCJT5I/CwBTvLPRGINKw3HZFyxs\nSzHFywIfe7498qRwUOdgAAeSy+mysmXXk5Kn2INP4QKBgQD3QmS+IFK1NcBWGWte\nSLOdbOpZeopJ+D9Z0VeG9JGUluOLyrQHmHfKc+nY3mQOoY5VKEkAvW25qp3c+PG4\n32deu5tR3UTEcMxiyeB2dQ8zpnAGGzFXWdCIFXDwaJngnDZhh5PM3YH9FRCC/Hh/\neMdqb+BEbxsCiJ1Og46MRj/B0QKBgQDKKmyzhc+AOXS1Jdhit//vNuGe7KaDv1r+\nycelYA5F4TI8rcKbb+VC1wesp2lJnty1r03yWFNodG9EFSxWLY8T1YGauSW7pnVQ\nwUrG1J1D0+p5p3/hWaYabiBzsiDflbsa2AJ2qTsCQQqgn9Abc5DdQ/JUSsWWgNSb\n/PRlDWDGOwKBgB1YUeCGsYo0IOmXBrkf48FRRdbsxjDVN5+PStYHfKen6MWUfx1P\nqRfr/drxOerKnbvZliByWu1oJGgvW3DXgsspdNuYaSrvQDKRRwSIDA/TNwRigc6e\nKDOeZ9MAdxLDN2kH0DDGMUE6GMWS9TIbwX8OXA2DKi94y0KgNnDLfZGhAoGAWD4Y\nYGvh3Lg3hvJT9xMVdZbg+HuXWx5lW507taWt1TastOurbCl1Sq2NPgF85ZOgBvXT\n8ho3nfpkrrUHOz57m06wWZbDL5tCzdLxDsSzOG4BhMRl/zkgVZ0IMTfpPW6f0uHC\ngYTwqtU1DFN1hOX2r33/Amf4wu7M3qGVE565RQ0CgYAdSwfTpJAEqtLm0TS9WZql\n/ky0mJv5K9VS5HUfpKFxTZHcKthUICm+2OcQZfE7NZZwi9FPaY+DqEniYy+7NByy\nBbyr+7dYuPQ82Qcg0mSQnD69cyplvUkrhCDdvVco7r4FCAq33yoKDIkl//TT6rYz\n9LRDUzEW19C3euqVCW+1gw==";

    public String testCreateToken(String jsonStr) throws InvalidKeySpecException, NoSuchAlgorithmException {
        String x509String = PUBLIC_KEY_X509_B64VALUE.replace("\n", "");
        String pkcs8String = PRIVATE_KEY_PKCS8_B64VALUE.replace("\n", "");
        KeyPair kp = KeyPairUtil.getFromBase64_X509_PKCS8("RSA", x509String, pkcs8String);
        long nowMillis = System.currentTimeMillis();
        JsoToMap token = new JsoToMap();
        Map<String, Object> tokenData = token.JsoToMap(jsonStr);
        HashMap<String, Object> header = new HashMap<String, Object>();
        header.put("alg", "RSA");
        header.put("typ", "JWT");
        String jwt = Jwts.builder().setClaims(tokenData).setHeader(header).signWith(SignatureAlgorithm.RS256, kp.getPrivate()).compact();
        return jwt;
    }
}

